<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

// Admin Check
if (checkAdmin($udata['type']) !== true) {
    echo "<script>window.location.href='index.php';</script>";
    exit;
}

$result_data = null;
$error_msg = '';
$success_msg = '';

// Handle Form Submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['aadhaar'])) {
    $aadhaar = trim(mysqli_real_escape_string($ahk_conn, $_POST['aadhaar']));
    
    // Basic validation
    if (strlen($aadhaar) === 12 && is_numeric($aadhaar)) {
        
        // Use centralized configuration
        if (empty($new_api_key) || empty($new_api_url)) {
             $error_msg = "System Error: New API Configuration Missing. Please check settings.";
        } else {
            // Build URL
            $base = rtrim($new_api_url, '/');
            // Ensure we point to the index.php if not already included in base url (though usually base is just the domain/path)
            // But based on npci_status_check: $url = $base . '/index.php?'...
            
            // Check if base already ends with index.php
            if (strpos($base, 'index.php') !== false) {
                $url = $base;
            } else {
                $url = $base . '/index.php';
            }
            
            $full_url = $url . '?' . http_build_query([
                'api_key' => $new_api_key,
                'service' => 'eshram',
                'uid'     => $aadhaar
            ]);

            // Initialize CURL
            $ch = curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => $full_url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_TIMEOUT => 60,
                CURLOPT_USERAGENT => 'LostData Admin Client/1.0'
            ]);

            $response = curl_exec($ch);
            $curl_error = curl_error($ch);
            curl_close($ch);

            if ($curl_error) {
                $error_msg = "API Connection Error: " . $curl_error;
            } else {
                $api = json_decode($response, true);
                
                // Check API Success (Status Code 200 is standard for this provider)
                if (isset($api['response_code']) && $api['response_code'] == 200 && isset($api['data']['data'])) {
                     $result_data = $api['data']['data'];
                     // Handle Aadhaar field name mismatch
                     if (!isset($result_data['aadhaar_no']) && isset($result_data['aadhaar'])) {
                         $result_data['aadhaar_no'] = $result_data['aadhaar'];
                     }
                     // Handle DOB
                     if (!isset($result_data['dateOfBirth']) && isset($result_data['dob'])) {
                         $result_data['dateOfBirth'] = $result_data['dob'];
                     }
                     // Handle Gender
                     if (!isset($result_data['genderCode']) && isset($result_data['gender'])) {
                         $result_data['genderCode'] = $result_data['gender'];
                     }
                     // Handle Relation Name
                     if (!isset($result_data['r_name']) && isset($result_data['relation_name'])) {
                         $result_data['r_name'] = $result_data['relation_name'];
                     }
                     // Handle Full Address
                     if (!isset($result_data['full_address']) && isset($result_data['address'])) {
                         $result_data['full_address'] = $result_data['address'];
                     }
                     
                     $success_msg = "Details fetched successfully for Aadhaar: " . htmlspecialchars($aadhaar);
                } else {
                     $error_msg = $api['message'] ?? $api['data']['message'] ?? 'Data not found or API failed.';
                }
            }
        }
    } else {
        $error_msg = "Invalid Aadhaar Number. Please enter a valid 12-digit Aadhaar.";
    }
}
?>

<div class="page-wrapper">
    <div class="page-content">
        <!-- Breadcrumb -->
        <div class="page-breadcrumb d-flex align-items-center justify-content-between mb-4 p-3 bg-white rounded shadow-sm">
            <div class="d-flex align-items-center">
                <div class="breadcrumb-title pe-3">Admin Services</div>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 ps-2">
                        <li class="breadcrumb-item active text-muted" aria-current="page">UID Eshram Details</li>
                    </ol>
                </nav>
            </div>
        </div>

        <div class="container-fluid pt-4 px-4">
            <div class="row">
                <!-- Search Form -->
                <div class="col-lg-12 mb-4">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title mb-4">Search Eshram Details</h5>
                            <form method="POST" class="row g-3">
                                <div class="col-md-8">
                                    <input type="text" name="aadhaar" class="form-control" placeholder="Enter 12-digit Aadhaar Number" 
                                           value="<?= isset($_POST['aadhaar']) ? htmlspecialchars($_POST['aadhaar']) : '' ?>" 
                                           required maxlength="12" pattern="\d{12}">
                                </div>
                                <div class="col-md-4">
                                    <button type="submit" class="btn btn-primary w-100">Search</button>
                                </div>
                            </form>
                            
                            <?php if($error_msg): ?>
                                <div class="alert alert-danger mt-3" role="alert">
                                    <?= htmlspecialchars($error_msg) ?>
                                </div>
                            <?php endif; ?>
                            
                            <?php if($success_msg): ?>
                                <div class="alert alert-success mt-3" role="alert">
                                    <?= htmlspecialchars($success_msg) ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Results Display -->
                <?php if($result_data): ?>
                <div class="col-lg-12">
                    <div class="card border-top border-0 border-4 border-primary">
                        <div class="card-body p-5">
                            <div class="card-title d-flex align-items-center">
                                <div><i class="bx bxs-user me-1 font-22 text-primary"></i></div>
                                <h5 class="mb-0 text-primary">E-Shram Details</h5>
                            </div>
                            <hr>
                            
                            <div class="row g-3">
                                <!-- Photo -->
                                <div class="col-md-4 text-center">
                                    <?php if(!empty($result_data['photo'])): 
                                        $photo_src = $result_data['photo'];
                                        if (strpos($photo_src, 'data:image') === false) {
                                            $photo_src = 'data:image/jpeg;base64,' . $photo_src;
                                        }
                                    ?>
                                        <img src="<?= $photo_src ?>" alt="User Photo" class="img-fluid rounded shadow-sm" style="max-height: 250px;">
                                    <?php else: ?>
                                        <div class="alert alert-secondary">No Photo Available</div>
                                    <?php endif; ?>
                                    <div class="mt-2 text-muted">
                                        <strong>Aadhaar:</strong> <?= htmlspecialchars($result_data['aadhaar_no'] ?? $result_data['uid'] ?? 'N/A') ?>
                                    </div>
                                </div>

                                <!-- Details -->
                                <div class="col-md-8">
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label text-secondary">Full Name</label>
                                            <div class="h6"><?= htmlspecialchars($result_data['name'] ?? '-') ?></div>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label text-secondary">Date of Birth</label>
                                            <div class="h6"><?= htmlspecialchars($result_data['dateOfBirth'] ?? '-') ?></div>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label text-secondary">Gender</label>
                                            <div class="h6"><?= htmlspecialchars($result_data['genderCode'] ?? '-') ?></div>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label text-secondary">Mobile Number</label>
                                            <div class="h6"><?= htmlspecialchars($result_data['mobile'] ?? '-') ?></div>
                                        </div>
                                        <div class="col-md-12 mb-3">
                                            <label class="form-label text-secondary">Relation (<?= htmlspecialchars($result_data['relation_type'] ?? 'N/A') ?>)</label>
                                            <div class="h6"><?= htmlspecialchars($result_data['r_name'] ?? '-') ?></div>
                                        </div>
                                        <div class="col-md-12 mb-3">
                                            <label class="form-label text-secondary">Full Address</label>
                                            <div class="p-2 bg-light border rounded">
                                                <?= htmlspecialchars($result_data['full_address'] ?? '-') ?>
                                            </div>
                                        </div>
                                    </div>

                                    <?php if(!empty($result_data['split_address'])): ?>
                                    <h6 class="mt-4 text-primary">Address Details</h6>
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-sm">
                                            <tbody>
                                                <tr>
                                                    <th>House No</th>
                                                    <td><?= htmlspecialchars($result_data['split_address']['house_no'] ?? '-') ?></td>
                                                    <th>Locality</th>
                                                    <td><?= htmlspecialchars($result_data['split_address']['locality'] ?? '-') ?></td>
                                                </tr>
                                                <tr>
                                                    <th>Village</th>
                                                    <td><?= htmlspecialchars($result_data['split_address']['village'] ?? '-') ?></td>
                                                    <th>Subdistrict</th>
                                                    <td><?= htmlspecialchars($result_data['split_address']['subdistrict'] ?? '-') ?></td>
                                                </tr>
                                                <tr>
                                                    <th>District</th>
                                                    <td><?= htmlspecialchars($result_data['split_address']['district'] ?? '-') ?></td>
                                                    <th>State</th>
                                                    <td><?= htmlspecialchars($result_data['split_address']['state'] ?? '-') ?></td>
                                                </tr>
                                                <tr>
                                                    <th>Pincode</th>
                                                    <td colspan="3"><?= htmlspecialchars($result_data['split_address']['pincode'] ?? '-') ?></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php include('../template/ahkweb/footer.php'); ?>
